//
//  Editing_Videos_on_an_iOS_DeviceViewController.m
//  Editing Videos on an iOS Device
//
//  Created by Vandad Nahavandipoor on 22/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Editing_Videos_on_an_iOS_DeviceViewController.h"

@implementation Editing_Videos_on_an_iOS_DeviceViewController

@synthesize videoURLToEdit;

- (void)videoEditorController:(UIVideoEditorController *)editor
     didSaveEditedVideoToPath:(NSString *)editedVideoPath{
  NSLog(@"Edytor wideo zakończył operację zapisu filmu");
  NSLog(@"Ścieżka dostępu zapisanego filmu to = %@", editedVideoPath);
  [editor dismissModalViewControllerAnimated:YES];
}

- (void)videoEditorController:(UIVideoEditorController *)editor
             didFailWithError:(NSError *)error{
  NSLog(@"Wystąpił błąd podczas edycji filmu = %@", error);
  [editor dismissModalViewControllerAnimated:YES];
}

- (void)videoEditorControllerDidCancel:(UIVideoEditorController *)editor{
  NSLog(@"Działanie edytora wideo zostało przerwane");
  [editor dismissModalViewControllerAnimated:YES];
}

- (void)    imagePickerController:(UIImagePickerController *)picker
    didFinishPickingMediaWithInfo:(NSDictionary *)info{
  
  NSLog(@"Udało się utworzyć obiekt.");
  
  NSString     *mediaType = [info objectForKey:
                             UIImagePickerControllerMediaType];
  
  if ([mediaType isEqualToString:(NSString *)kUTTypeMovie]){
    self.videoURLToEdit = [info objectForKey:UIImagePickerControllerMediaURL];  
  }
  
  [picker dismissModalViewControllerAnimated:YES];
  
}

- (void) imagePickerControllerDidCancel:(UIImagePickerController *)picker{
  
  NSLog(@"Obiekt został usunięty z pamięci");
  self.videoURLToEdit = nil;
  [picker dismissModalViewControllerAnimated:YES];
  
}

- (BOOL) cameraSupportsMedia:(NSString *)paramMediaType
                  sourceType:(UIImagePickerControllerSourceType)paramSourceType{
  
  __block BOOL result = NO;
  
  if ([paramMediaType length] == 0){
    NSLog(@"Ten komponent jest nieobsługiwany.");
    return NO;
  }
  
  NSArray *availableMediaTypes = 
  [UIImagePickerController availableMediaTypesForSourceType:paramSourceType];
  
  [availableMediaTypes enumerateObjectsUsingBlock:
   ^(id obj, NSUInteger idx, BOOL *stop) {
     
     NSString *mediaType = (NSString *)obj;
     if ([mediaType isEqualToString:paramMediaType]){
       result = YES;
       *stop= YES;
     }
     
   }];
  
  return result;
  
}

- (BOOL) canUserPickVideosFromPhotoLibrary{
  
  return [self cameraSupportsMedia:(__bridge NSString *)kUTTypeMovie
               sourceType:UIImagePickerControllerSourceTypePhotoLibrary];
  
}

- (BOOL) isPhotoLibraryAvailable{
  
  return [UIImagePickerController
          isSourceTypeAvailable:
          UIImagePickerControllerSourceTypePhotoLibrary];
  
}

- (void)viewDidLoad {
  [super viewDidLoad];
  
  if ([self isPhotoLibraryAvailable] &&
      [self canUserPickVideosFromPhotoLibrary]){
    
    UIImagePickerController *imagePicker =
      [[UIImagePickerController alloc] init];
    
    /* Ustawienie źródła jako biblioteki aplikacji Zdjęcia */
    imagePicker.sourceType = UIImagePickerControllerSourceTypePhotoLibrary;
    
    /* Użytkownik ma mieć możliwość wyboru filmu z biblioteki */
    NSArray  *mediaTypes = [[NSArray alloc] initWithObjects:
                            (__bridge NSString *)kUTTypeMovie, nil];
    
    imagePicker.mediaTypes = mediaTypes;
    
    /* Ustawienie bieżącego kontrolera widoku jako delegata */
    imagePicker.delegate = self;
    
    /* Wyświetlenie interfejsu służącego do wyboru filmu */
    [self.navigationController presentModalViewController:imagePicker
                                                 animated:YES];
    
  }
  
}

- (void) viewDidAppear:(BOOL)animated{
  [super viewDidAppear:animated];
  
  if (self.videoURLToEdit != nil){
    
    NSString *videoPath = [self.videoURLToEdit path];
    
    /* Najpierw trzeba się upewnić, że edytor wideo ma możliwość
      edycji pliku znajdującego się w podanej ścieżce dostępu do katalogu Documents. */
    if ([UIVideoEditorController canEditVideoAtPath:videoPath]){
      
      /* Utworzenie edytora wideo. */
      UIVideoEditorController *videoEditor =
      [[UIVideoEditorController alloc] init];
      
      /* Kontroler widoku staje się delegatem edytora wideo. */
      videoEditor.delegate = self;
      
      /* Upewniamy się, że ustawiona została ścieżka dostępu do pliku filmu. */
      videoEditor.videoPath = videoPath;
      
      /* Wyświetlenie edytora wideo użytkownikowi. */
      [self.navigationController presentModalViewController:videoEditor
                                                   animated:YES];
      
      self.videoURLToEdit = nil;
      
    } else {
      NSLog(@"Nie można edytować pliku znajdującego się w podanej ścieżce dostępu.");
    }
    
  }
  
}

- (BOOL)shouldAutorotateToInterfaceOrientation
        :(UIInterfaceOrientation)interfaceOrientation{
  return YES;
}

@end
